import tensorflow as tf

def weighted_lra(matrix, weight, rank, epochs=100):
  matrix = tf.constant(value=matrix, dtype=tf.float32)
  weight = tf.constant(value=weight, dtype=tf.float32)
  n, d = matrix.shape
  left_factor = tf.random.normal(shape=[n, rank], dtype=tf.float32)
  left_factor = tf.Variable(initial_value=left_factor, trainable=True)
  right_factor = tf.random.normal(shape=[rank, d], dtype=tf.float32)
  right_factor = tf.Variable(initial_value=right_factor, trainable=True)

  def weighted_loss() -> tf.Tensor:
    y_true = matrix
    y_pred = left_factor @ right_factor
    sqrt_weight = tf.math.sqrt(weight)
    diff = sqrt_weight * (y_true - y_pred)
    return tf.math.reduce_euclidean_norm(diff)

  schedule = tf.keras.optimizers.schedules.ExponentialDecay(
    initial_learning_rate=1.0, decay_rate=0.7, decay_steps=10
  )
  optimizer = tf.keras.optimizers.Adam(learning_rate=schedule)
  for _ in range(epochs):
    optimizer.minimize(weighted_loss, var_list=[left_factor, right_factor])
  return left_factor.numpy(), right_factor.numpy()
